/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import net.minecraft.class_1297;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;

public interface GeoEntity
extends GeoAnimatable {
    @ApiStatus.NonExtendable
    default public <D> @Nullable D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((class_1297)this).method_5628()).getAnimatableData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        class_1297 entity = (class_1297)this;
        if (entity.method_73183().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).setAnimatableData(dataTicket, data);
        } else {
            GeckoLibServices.NETWORK.syncEntityAnimData(entity, false, dataTicket, data);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String controllerName, String animName) {
        class_1297 entity = (class_1297)this;
        if (entity.method_73183().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(entity.method_5628());
            if (controllerName != null) {
                animatableManager.tryTriggerAnimation(controllerName, animName);
            } else {
                animatableManager.tryTriggerAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.triggerEntityAnim(entity, false, controllerName, animName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@Nullable String controllerName, @Nullable String animName) {
        class_1297 entity = (class_1297)this;
        if (entity.method_73183().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(entity.method_5628());
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.stopTriggeredEntityAnim(entity, false, controllerName, animName);
        }
    }
}

